package ru.yandex.chemodan.app.dataapi.core.limiter.access;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.test.Assert;

import static org.mockito.Mockito.any;
import static org.mockito.Mockito.mock;
import static org.mockito.Mockito.when;

/**
 * @author tolmalev
 */
public class DataApiAccessRateLimiterTest {
    @Test
    public void checkComplexLimits() {
        AccessRateLimitsRegistry registry = mock(AccessRateLimitsRegistry.class);
        DataApiAccessRateLimiter limiter = new DataApiAccessRateLimiter(registry);

        when(registry.getLimits(any(), any(), any())).thenReturn(
                Cf.list(
                    new AccessRateLimits(AccessRateLimits.Type.BY_CLIENT, "app", Option.empty(), 50),
                    new AccessRateLimits(AccessRateLimits.Type.BY_CLIENT, "app", Option.of("db"), 20),
                    new AccessRateLimits(AccessRateLimits.Type.BY_HOST, "h_app", Option.empty(), 70),
                    new AccessRateLimits(AccessRateLimits.Type.BY_HOST, "h_app", Option.of("db"), 10)
                )
        );

        limiter.checkLimits(Option.of("app"), Option.of("app"), "dbId", new LimitingCountersValue(
                1, 2, 3, 4
        ));

        limiter.checkLimits(Option.of("app"), Option.of("app"), "dbId", new LimitingCountersValue(
                50, 20, 70, 10
        ));


        Assert.assertThrows(() -> limiter.checkLimits(Option.of("app"), Option.of("app"), "dbId",
                new LimitingCountersValue(
                        51, 20, 70, 10
                )),
                AccessRateLimitException.class
        );

        Assert.assertThrows(() -> limiter.checkLimits(Option.of("app"), Option.of("app"), "dbId",
                new LimitingCountersValue(
                        50, 21, 70, 10
                )),
                AccessRateLimitException.class
        );

        Assert.assertThrows(() -> limiter.checkLimits(Option.of("app"), Option.of("app"), "dbId",
                new LimitingCountersValue(
                        50, 20, 71, 10
                )),
                AccessRateLimitException.class
        );

        Assert.assertThrows(() -> limiter.checkLimits(Option.of("app"), Option.of("app"), "dbId",
                new LimitingCountersValue(
                        50, 20, 70, 11
                )),
                AccessRateLimitException.class
        );
    }
}
