package ru.yandex.chemodan.app.dataapi.core.logbroker;

import ru.yandex.chemodan.app.dataapi.api.DatabaseChangedEventAsyncHandler;
import ru.yandex.chemodan.app.dataapi.api.deltas.DatabaseChange;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.commune.bazinga.impl.JobId;
import ru.yandex.misc.ExceptionUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author dbrylev
 */
public class BazingaFallbackLogBrokerPushEventHandler implements DatabaseChangedEventAsyncHandler {

    private static final Logger logger = LoggerFactory.getLogger(BazingaFallbackLogBrokerPushEventHandler.class);

    private final LogBrokerPushEventHandler baseHandler;
    private final BazingaTaskManager taskManager;

    public BazingaFallbackLogBrokerPushEventHandler(
            LogBrokerPushEventHandler baseHandler, BazingaTaskManager taskManager)
    {
        this.baseHandler = baseHandler;
        this.taskManager = taskManager;
    }

    @Override
    public void databaseChanged(DatabaseChange databaseChange) {
        baseHandler.prepareAndSend(databaseChange).iterator().filter(t -> t.get2().isPresent()).forEachRemaining(rejected -> {
            try {
                JobId id = taskManager.schedule(new LogBrokerPushRecordChangeTask(rejected.get1())).getJobId();

                logger.info("Failed change pushing submitted into bazinga {}: {}",
                        id, ExceptionUtils.getAllMessages(rejected.get2().get()));

            } catch (RuntimeException e) {
                e.addSuppressed(rejected.get2().get());
                throw e;
            }
        });
    }

    @Override
    public int getOrder() {
        return HIGHEST_PRECEDENCE;
    }
}
