package ru.yandex.chemodan.app.dataapi.core.logbroker;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.dataapi.core.dump.RecordChangeEvent;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.commune.bazinga.impl.FullJobId;
import ru.yandex.commune.bazinga.scheduler.OnetimeTask;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.misc.test.Assert;

/**
 * @author dbrylev
 */
@RunWith(MockitoJUnitRunner.class)
public class BazingaFallbackLogBrokerPushEventHandlerTest {

    @Mock
    private LogBrokerPushEventHandler baseHandler;
    @Mock
    private BazingaTaskManager taskManager;
    @Mock
    private RecordChangeEvent event1;
    @Mock
    private RecordChangeEvent event2;
    @Mock
    private RecordChangeEvent event3;


    private BazingaFallbackLogBrokerPushEventHandler handler;

    @Before
    public void setup() {
        handler = new BazingaFallbackLogBrokerPushEventHandler(baseHandler, taskManager);
    }

    @Test
    public void successHandling() {
        Mockito.when(baseHandler.prepareAndSend(Mockito.any()))
                .thenReturn(Tuple2List.fromPairs(event1, Option.empty()));

        handler.databaseChanged(null);

        Mockito.verify(baseHandler).prepareAndSend(Mockito.any());
        Mockito.verifyZeroInteractions(taskManager);
    }

    @Test
    public void errorHandling() {
        ArgumentCaptor<OnetimeTask> taskCaptor = ArgumentCaptor.forClass(OnetimeTask.class);

        Option<Exception> sent = Option.empty();
        Option<Exception> failed = Option.of(new SendingException());

        Mockito.when(baseHandler.prepareAndSend(Mockito.any())).thenReturn(
                Tuple2List.fromPairs(event1, failed, event2, sent, event3, failed));

        Mockito.when(taskManager.schedule(taskCaptor.capture()))
                .thenReturn(new FullJobId(null, null))
                .thenThrow(new BazingaException());

        Assert.assertThrows(() -> handler.databaseChanged(null), BazingaException.class);

        Assert.equals(Cf.list(event1, event3), Cf.x(taskCaptor.getAllValues())
                .cast(LogBrokerPushRecordChangeTask.class)
                .map(OnetimeTaskSupport::getParametersTyped).map(p -> p.event));
    }

    private static class SendingException extends RuntimeException {}

    private static class BazingaException extends RuntimeException {}
}
