package ru.yandex.chemodan.app.dataapi.core.logbroker;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.dataapi.apps.AppsContextConfiguration;
import ru.yandex.chemodan.app.dataapi.apps.settings.AppSettingsRegistry;
import ru.yandex.chemodan.app.dataapi.core.generic.TypeSettingsRegistry;
import ru.yandex.chemodan.app.dataapi.core.generic.TypeSettingsRegistryContextConfiguration;
import ru.yandex.chemodan.bazinga.ChemodanBazingaClientContextConfiguration;
import ru.yandex.commune.bazinga.BazingaTaskManager;

/**
 * @author dbrylev
 */
@Configuration
@Import({
        AppsContextConfiguration.class,
        TypeSettingsRegistryContextConfiguration.class,
        ChemodanBazingaClientContextConfiguration.class,
        LogBrokerPushSenderContextConfiguration.class,
})
public class LogBrokerHandlerContextConfiguration {

    @Bean
    public BazingaFallbackLogBrokerPushEventHandler logBrokerPushEventHandler(
            LogBrokerPushSender sender, BazingaTaskManager bazingaTaskManager,
            AppSettingsRegistry appsRegistry, TypeSettingsRegistry typesRegistry)
    {
        LogBrokerPushEventHandler baseHandler = new LogBrokerPushEventHandler(sender, appsRegistry, typesRegistry);

        return new BazingaFallbackLogBrokerPushEventHandler(baseHandler, bazingaTaskManager);
    }
}
