package ru.yandex.chemodan.app.dataapi.core.logbroker;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function1V;
import ru.yandex.chemodan.app.dataapi.api.DatabaseChangedEventAsyncHandler;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.deltas.DatabaseChange;
import ru.yandex.chemodan.app.dataapi.apps.settings.AppSettingsRegistry;
import ru.yandex.chemodan.app.dataapi.core.dump.DatabaseChangesTskvLogger;
import ru.yandex.chemodan.app.dataapi.core.dump.MethodType;
import ru.yandex.chemodan.app.dataapi.core.dump.RecordChangeEvent;
import ru.yandex.chemodan.app.dataapi.core.generic.TypeLocation;
import ru.yandex.chemodan.app.dataapi.core.generic.TypeSettings;
import ru.yandex.chemodan.app.dataapi.core.generic.TypeSettingsRegistry;
import ru.yandex.misc.ExceptionUtils;

/**
 * @author dbrylev
 */
public class LogBrokerPushEventHandler implements DatabaseChangedEventAsyncHandler {

    private final LogBrokerPushSender sender;
    private final AppSettingsRegistry appsRegistry;
    private final TypeSettingsRegistry typesRegistry;

    public LogBrokerPushEventHandler(
            LogBrokerPushSender sender,
            AppSettingsRegistry appsRegistry,
            TypeSettingsRegistry typesRegistry)
    {
        this.sender = sender;
        this.appsRegistry = appsRegistry;
        this.typesRegistry = typesRegistry;
    }

    @Override
    public void databaseChanged(DatabaseChange databaseChange) {
        Tuple2List<RecordChangeEvent, Option<Exception>> result = prepareAndSend(databaseChange);

        ListF<Exception> exceptions = result.filterMap(Tuple2::get2);

        if (exceptions.isNotEmpty()) {
            throw new RuntimeException(
                    "Failed to push some of database changes: " + exceptions.map(ExceptionUtils::getAllMessages));
        }
    }

    public Tuple2List<RecordChangeEvent, Option<Exception>> prepareAndSend(DatabaseChange change) {
        if (appsRegistry.getDatabaseSettings(change.sourceDatabase()).getLbPushLogTypeName().isPresent()) {
            Database database = change.sourceDatabase();

            ListF<RecordChangeEvent> events = Cf.arrayList();

            Function<DataRecord, Option<TypeSettings>> typeF = rec -> typesRegistry.getTypeSettings(
                    new TypeLocation(database.appNameO(), database.databaseId(), rec.getCollectionId()));

            Function<MethodType, Function1V<DataRecord>> addF = method ->
                    rec -> events.add(RecordChangeEvent.cons(method, database, rec, typeF.apply(rec),
                            DatabaseChangesTskvLogger.getYcrid(), DatabaseChangesTskvLogger.getDataapiRequestApp()));

            change.getNewRecords().forEach(addF.apply(MethodType.INSERT));
            change.getUpdatedRecords().forEach(addF.apply(MethodType.UPDATE));
            change.getDeletedRecordsWithLastRev().forEach(addF.apply(MethodType.DELETE));

            return events.zip(sender.send(events));

        } else {
            return Tuple2List.tuple2List();
        }
    }

    @Override
    public int getOrder() {
        return HIGHEST_PRECEDENCE;
    }
}
