package ru.yandex.chemodan.app.dataapi.core.logbroker;

import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataFields;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.data.snapshot.PatchableSnapshot;
import ru.yandex.chemodan.app.dataapi.api.data.snapshot.Snapshot;
import ru.yandex.chemodan.app.dataapi.api.data.snapshot.SnapshotPojoRow;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.db.handle.DatabaseHandle;
import ru.yandex.chemodan.app.dataapi.api.deltas.Delta;
import ru.yandex.chemodan.app.dataapi.api.deltas.RecordChange;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiPassportUserId;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.apps.settings.AppDatabaseSettings;
import ru.yandex.chemodan.app.dataapi.apps.settings.AppSettingsRegistry;
import ru.yandex.chemodan.app.dataapi.core.dump.MethodType;
import ru.yandex.chemodan.app.dataapi.core.dump.RecordChangeEvent;
import ru.yandex.chemodan.app.dataapi.core.generic.TypeLocation;
import ru.yandex.chemodan.app.dataapi.core.generic.TypeSettingsRegistry;
import ru.yandex.misc.test.Assert;

/**
 * @author dbrylev
 */
@RunWith(MockitoJUnitRunner.class)
public class LogBrokerPushEventHandlerTest {

    @Mock
    private LogBrokerPushSender sender;
    @Mock
    private AppSettingsRegistry registry;
    @Mock
    private AppDatabaseSettings settings;
    @Mock
    private TypeSettingsRegistry types;

    private LogBrokerPushEventHandler handler;

    @Before
    public void setup() {
        handler = new LogBrokerPushEventHandler(sender, registry, types);

        Mockito.when(registry.getDatabaseSettings(Mockito.any())).thenReturn(settings);
        Mockito.when(settings.getLbPushLogTypeName()).thenReturn(Option.of("xxx"));

        Mockito.when(types.getTypeSettings(Mockito.<TypeLocation>any())).thenReturn(Option.empty());

        Mockito.when(sender.send(Mockito.any()))
                .thenAnswer(i -> Cf.repeat(Option::empty, ((ListF) i.getArguments()[0]).size()));
    }

    @Test
    public void prepareAndSend() {
        ListF<SnapshotPojoRow> rowsStart = Cf.list(
                new SnapshotPojoRow("col", "rec0", DataFields.EMPTY, 0),
                new SnapshotPojoRow("col", "rec1", DataFields.EMPTY, 0));

        Delta delta = new Delta(Cf.list(
                RecordChange.delete("col", "rec0"),
                RecordChange.update("col", "rec1", Cf.list()),
                RecordChange.insert("col", "rec2", Cf.map())));

        DataApiUserId user = new DataApiPassportUserId(1L);
        DatabaseHandle handle = DatabaseHandle.consGlobal("dbId", "handle");

        Database database = Database.consNew(user, handle);
        Function<SnapshotPojoRow, DataRecord> toDataRecordF = row -> row.toDataRecordWithRef(user, handle);
        PatchableSnapshot snapshot = new Snapshot(database, rowsStart.map(toDataRecordF)).toPatchable().patch(delta);

        Tuple2List<RecordChangeEvent, Option<Exception>> result = handler.prepareAndSend(snapshot.toDatabaseChange());

        Assert.equals(
                Tuple2List.fromPairs("rec0", MethodType.DELETE, "rec1", MethodType.UPDATE, "rec2", MethodType.INSERT),
                result.get1().toTuple2List(e -> e.recordId, e -> e.method).reverse());

        Assert.forAll(result, t -> !t.get2().isPresent());
    }
}
