package ru.yandex.chemodan.app.dataapi.core.logbroker;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.dataapi.apps.AppsContextConfiguration;
import ru.yandex.chemodan.app.dataapi.apps.settings.AppSettingsRegistry;
import ru.yandex.chemodan.logbroker.PushClientFactory;
import ru.yandex.chemodan.logbroker.PushClientFactoryContextConfiguration;
import ru.yandex.commune.bazinga.scheduler.schedule.RescheduleConstant;
import ru.yandex.commune.bazinga.scheduler.schedule.ReschedulePolicy;

/**
 * @author dbrylev
 */
@Configuration
@Import({
        AppsContextConfiguration.class,
        PushClientFactoryContextConfiguration.class,
})
public class LogBrokerPushSenderContextConfiguration {

    @Bean
    public LogBrokerPushSender logBrokerPushSender(
            PushClientFactory pushClientFactory, AppSettingsRegistry settingsRegistry,
            @Value("${logbroker-sender.timeout}") Duration timeout)
    {
        ReschedulePolicy reschedule = new RescheduleConstant(Duration.millis(50), 10);

        return new LogBrokerPushSender(pushClientFactory, reschedule, timeout, settingsRegistry);
    }
}
