package ru.yandex.chemodan.app.dataapi.core.logbroker;

import java.util.concurrent.ExecutionException;

import com.google.common.util.concurrent.Futures;
import org.joda.time.Duration;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.db.ref.AppDatabaseRef;
import ru.yandex.chemodan.app.dataapi.apps.settings.AppDatabaseSettings;
import ru.yandex.chemodan.app.dataapi.apps.settings.AppSettingsRegistry;
import ru.yandex.chemodan.app.dataapi.core.dump.RecordChangeEvent;
import ru.yandex.chemodan.logbroker.PushClientFactory;
import ru.yandex.inside.logbroker.push.PushClient;
import ru.yandex.misc.test.Assert;
import ru.yandex.misc.thread.ExecutionRuntimeException;

/**
 * @author dbrylev
 */
@RunWith(MockitoJUnitRunner.class)
public class LogBrokerPushSenderTest {

    @Mock
    private PushClientFactory factory;
    @Mock
    private PushClient client;
    @Mock
    private AppSettingsRegistry registry;
    @Mock
    private AppDatabaseSettings settings;
    @Mock
    private RecordChangeEvent event;

    private LogBrokerPushSender sender;

    @Before
    public void setup() {
        sender = new LogBrokerPushSender(factory, null, Duration.ZERO, registry);

        Mockito.when(registry.getDatabaseSettings(Mockito.any())).thenReturn(settings);
        Mockito.when(settings.getLbPushLogTypeName()).thenReturn(Option.of("xxx"));

        Mockito.when(factory.buildAndStart(Mockito.any())).thenReturn(client);

        Mockito.when(event.getDbRef()).thenReturn(new AppDatabaseRef("app", "db"));
        Mockito.when(event.formatTskvLine()).thenReturn("");
    }

    @Test
    public void sendOrThrow() {
        Mockito.when(client.sendData(Mockito.any(), Mockito.any()))
                .thenReturn(Futures.immediateFuture(null));

        sender.sendOrThrow(event);

        Mockito.verify(client).sendData(Mockito.any(), Mockito.any());

        Mockito.when(client.sendData(Mockito.any(), Mockito.any()))
                .thenReturn(Futures.immediateFailedFuture(new FailureException()));

        Assert.assertThrows(() -> sender.sendOrThrow(event),
                ExecutionRuntimeException.class, e -> e.getCause() instanceof FailureException);
    }

    @Test
    public void sendOkAndFailed() {
        Mockito.when(client.sendData(Mockito.any(), Mockito.any()))
                .thenReturn(Futures.immediateFuture(null))
                .thenReturn(Futures.immediateFailedFuture(new FailureException()));

        ListF<Option<Exception>> result = sender.send(Cf.list(event, event));

        Assert.none(result.first());
        Assert.exists(result.last(), e -> e instanceof ExecutionException && e.getCause() instanceof FailureException);
    }

    private static class FailureException extends RuntimeException {}
}
