package ru.yandex.chemodan.app.dataapi.core.manager;

import java.util.function.Function;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function1V;
import ru.yandex.chemodan.app.dataapi.api.data.filter.RecordsFilter;
import ru.yandex.chemodan.app.dataapi.api.data.filter.condition.RecordCondition;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.data.record.RecordId;
import ru.yandex.chemodan.app.dataapi.api.data.record.RecordRef;
import ru.yandex.chemodan.app.dataapi.api.data.snapshot.Snapshot;
import ru.yandex.chemodan.app.dataapi.api.data.snapshot.SnapshotPojoRow;
import ru.yandex.chemodan.app.dataapi.api.data.snapshot.SnapshotWithSource;
import ru.yandex.chemodan.app.dataapi.api.datasource.DataSource;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.db.DatabaseDeletionMode;
import ru.yandex.chemodan.app.dataapi.api.db.ref.UserDatabaseSpec;
import ru.yandex.chemodan.app.dataapi.api.deltas.Delta;
import ru.yandex.chemodan.app.dataapi.api.deltas.DeltasAppliedDatabase;
import ru.yandex.chemodan.app.dataapi.api.deltas.RecordChange;
import ru.yandex.chemodan.app.dataapi.api.deltas.RevisionCheckMode;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.core.datasources.disk.LockedDatabaseSession;
import ru.yandex.chemodan.ratelimiter.chunk.ChunkRateLimiter;

/**
 * @author tolmalev
 */
public interface DataApiManager {
    boolean isNoKeepDeltas(UserDatabaseSpec databaseSpec);

    DataApiManagerImpl.TransactionalManagerSession openSession(DataSource dataSource, UserDatabaseSpec databaseSpec);

    Option<Database> getAndInitCopyOnWrite(UserDatabaseSpec databaseSpec);

    Database getDatabase(UserDatabaseSpec databaseSpec);

    Database getOrCreateDatabase(UserDatabaseSpec databaseSpec);

    void runWithLockedDatabase(UserDatabaseSpec databaseSpec, Function1V<LockedDatabaseSession> function);

    <R> R executeWithLockedDatabase(UserDatabaseSpec databaseSpec, Function<LockedDatabaseSession, R> function);

    Database createDatabase(UserDatabaseSpec databaseSpec);

    Option<Database> getDatabaseO(UserDatabaseSpec databaseSpec);

    void deleteDatabaseIfExists(UserDatabaseSpec databaseSpec, DatabaseDeletionMode deleteMode);

    void deleteDatabaseIfExists(UserDatabaseSpec databaseSpec, DatabaseDeletionMode deleteMode, ChunkRateLimiter rateLimiter);

    Database setDatabaseDescription(UserDatabaseSpec databaseSpec, Option<String> newTitle);

    Database createDatabaseWithDescription(UserDatabaseSpec databaseSpec, String title);

    void onDatabaseUpdate(UserDatabaseSpec databaseSpec, long rev);

    Delta getDelta(UserDatabaseSpec databaseSpec, long rev);

    ListF<Delta> listDeltas(UserDatabaseSpec databaseSpec, long fromRev, int limit);

    Database applyDelta(Database database, RecordChange change, RecordCondition ifMatch);

    Database applyDelta(Database database, RevisionCheckMode revCheckMode, Delta delta);

    Database applyDelta(UserDatabaseSpec databaseSpec, long rev, RevisionCheckMode revCheckMode,
                        Delta delta);

    DeltasAppliedDatabase applyDeltas(UserDatabaseSpec databaseSpec, long rev,
                                      RevisionCheckMode revCheckMode, ListF<Delta> deltas);

    default Snapshot getSnapshot(UserDatabaseSpec databaseSpec, RecordsFilter filter) {
        return getSnapshot(databaseSpec, filter, SnapshotSource.BY_CURRENT_POLICY);
    }

    default Option<Snapshot> getSnapshotO(UserDatabaseSpec databaseSpec, RecordsFilter filter) {
        return getSnapshotO(databaseSpec, filter, SnapshotSource.BY_CURRENT_POLICY);
    }

    Snapshot getSnapshot(UserDatabaseSpec databaseSpec, RecordsFilter filter, SnapshotSource source);

    Option<Snapshot> getSnapshotO(UserDatabaseSpec databaseSpec, RecordsFilter filter, SnapshotSource source);

    Option<SnapshotWithSource> getSnapshotWithRevisionO(UserDatabaseSpec dbSpec, Option<Long> rev, RecordsFilter filter);

    default Option<SnapshotWithSource> getSnapshotWithRevisionO(UserDatabaseSpec dbSpec, long rev, RecordsFilter filter)
    {
        return getSnapshotWithRevisionO(dbSpec, Option.of(rev), filter);
    }

    // admin-only
    Snapshot getSnapshot(UserDatabaseSpec databaseSpec);

    // internal API
    SnapshotPojoRow getSnapshotRow(DataApiUserId uid, RecordRef recordId);

    Option<DataRecord> getRecord(DataApiUserId uid, RecordRef recordRef);

    Option<DataRecord> getRecord(UserDatabaseSpec databaseSpec, RecordId recordId);

    ListF<DataRecord> getRecords(UserDatabaseSpec databaseSpec);

    ListF<DataRecord> getRecords(UserDatabaseSpec databaseSpec, RecordsFilter filter);

    int getRecordsCount(UserDatabaseSpec databaseSpec);

    int getRecordsCount(UserDatabaseSpec databaseSpec, RecordsFilter filter);

    ListF<Snapshot> takeout(DataApiUserId userId, ListF<Database> databases);
}
