package ru.yandex.chemodan.app.dataapi.core.mdssnapshot;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.chemodan.app.dataapi.api.data.filter.RecordsFilter;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.data.snapshot.Snapshot;

/**
 * @author osidorkin
 */
public class MdsSnapshotProcessor {

    public static Snapshot applyFilteringAndLimits(Snapshot originalSnapshot, RecordsFilter filter) {
        CollectionF<DataRecord> records = originalSnapshot.records.records().filter(filter::matches);

        if (filter.limits().isAll()) {
            records = records.sorted(filter.getRecordOrder().comparator());

        } else if (filter.limits().getFirst() < records.size()) {
            records = records.takeSorted(filter.getRecordOrder().comparator(),
                    filter.limits().getFirst(), filter.limits().getCount());

        } else {
            records = Cf.list();
        }
        return originalSnapshot.withRecords(records.toList());
    }
}
