package ru.yandex.chemodan.app.dataapi.core.mdssnapshot;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Denis Bakharev
 *
 * По mdsKey можно загрузить снапшот из MDS
 */
public class MdsSnapshotReference extends DefaultObject {
    public final String databaseHandle;
    public final long databaseRev;
    public final Instant lastRequestTime;
    public final DataApiUserId uid;
    public final Option<String> mdsKey;

    public MdsSnapshotReference(
            String databaseHandle, long databaseRev, Instant lastRequestTime, Option<String> mdsKey, DataApiUserId uid)
    {
        this.databaseHandle = databaseHandle;
        this.databaseRev = databaseRev;
        this.lastRequestTime = lastRequestTime;
        this.mdsKey = mdsKey;
        this.uid = uid;
    }
}
