package ru.yandex.chemodan.app.dataapi.core.mdssnapshot;

import org.joda.time.Instant;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.ratelimiter.chunk.ChunkRateLimiter;
import ru.yandex.commune.db.shard2.Shard2;
import ru.yandex.commune.test.random.RunWithRandomTest;

/**
 * @author tolmalev
 */
public interface MdsSnapshotReferenceJdbcDao {
    @RunWithRandomTest
    void insert(MdsSnapshotReference mdsSnapshotReference);

    void insertBatch(DataApiUserId uid, ListF<MdsSnapshotReference> references);

    @RunWithRandomTest
    int updateLastRequestTime(Instant lastRequestTime, Database database);

    @RunWithRandomTest
    int updateMdsKey(String mdsKey, Database database);

    @RunWithRandomTest
    Option<MdsSnapshotReference> find(DataApiUserId uid, String handle, long revision);

    @RunWithRandomTest
    ListF<MdsSnapshotReference> find(DataApiUserId uid, ListF<String> handles);

    @RunWithRandomTest
    int delete(MdsSnapshotReference snapshotReference);

    @RunWithRandomTest
    void delete(DataApiUserId uid, ListF<String> handles);

    @RunWithRandomTest
    void delete(DataApiUserId uid, ListF<String> handles, ChunkRateLimiter rateLimiter);

    @RunWithRandomTest
    ListF<MdsSnapshotReference> findAllWithCreationTimeLessThan(DataApiUserId uid, Instant instant);

    @RunWithRandomTest
    ListF<MdsSnapshotReference> findAllWithCreationTimeLessThan(Instant instant);

    ListF<MdsSnapshotReference> findAllWithCreationTimeLessThan(Instant instant, Shard2 shard);
}
