package ru.yandex.chemodan.app.dataapi.core.mdssnapshot;

import java.sql.ResultSet;
import java.sql.SQLException;

import org.joda.time.Instant;
import org.springframework.jdbc.core.RowMapper;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;

/**
 * @author Denis Bakharev
 */
public class MdsSnapshotReferenceMapper implements RowMapper<MdsSnapshotReference> {

    @Override
    public MdsSnapshotReference mapRow(ResultSet rs, int rowNum) throws SQLException {
        return new MdsSnapshotReference(
                rs.getString("database_handle"),
                rs.getLong("database_rev"),
                new Instant(rs.getTimestamp("last_request_time")),
                Option.ofNullable(rs.getString("mds_key")),
                DataApiUserId.parse(rs.getString("user_id")));
    }
}
