package ru.yandex.chemodan.app.dataapi.core.ratelimiter.chunk.auto;

import org.joda.time.Duration;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function0;
import ru.yandex.chemodan.app.dataapi.core.dao.ForcedUserShardInfoHolder;
import ru.yandex.chemodan.ratelimiter.chunk.auto.AutoContextAwareRwRateLimiterMapSupport;
import ru.yandex.chemodan.ratelimiter.chunk.auto.HostKey;
import ru.yandex.chemodan.ratelimiter.chunk.auto.MasterSlave;
import ru.yandex.chemodan.ratelimiter.chunk.auto.MetricsConfiguration;
import ru.yandex.chemodan.ratelimiter.chunk.auto.RateLimitersMetrics;
import ru.yandex.chemodan.util.yasm.monitor.YasmMonitor;
import ru.yandex.commune.db.shard2.ShardManager2;
import ru.yandex.misc.db.masterSlave.MasterSlaveContextHolder;

/**
 * @author yashunsky
 */
public class AutoContextAwareRwRateLimiter extends AutoContextAwareRwRateLimiterMapSupport {
    public AutoContextAwareRwRateLimiter(ShardManager2 dataShardManager,
            YasmMonitor yasmMonitor, MetricsConfiguration metricsConfiguration,
            RateLimitersMetrics rateLimitersMetrics, Function0<Double> getInitialRateF,
            Function<Integer, Double> getMaxRateF, Function0<Double> getRateIncStepF,
            Function0<Double> getRateDecStepF, Function0<Double> getReadRateCoeffF,
            Function0<Double> getWriteRateCoeffF, Function0<Double> getMinUsageF,
            Function0<ListF<String>> getIgnoredHostsF,
            Function0<Boolean> getIsAutoEnabledF, Function0<Long> getMaxTimeSlotF,
            Function0<Option<Long>> getMaxAwaitTimeF,
            Function0<Integer> getDefaultChunkSizeF, Duration meterInterval, Duration averageInterval)
    {
        super(dataShardManager, yasmMonitor, metricsConfiguration, rateLimitersMetrics, getInitialRateF, getMaxRateF,
                getRateIncStepF, getRateDecStepF, getReadRateCoeffF, getWriteRateCoeffF, getMinUsageF, getIgnoredHostsF,
                getIsAutoEnabledF, getMaxTimeSlotF, getMaxAwaitTimeF, getDefaultChunkSizeF, meterInterval,
                averageInterval);
    }

    @Override
    protected HostKey resolveKeyFromContext() {
        int shardId = ForcedUserShardInfoHolder.getO().getOrThrow(() -> new IllegalStateException(
                "Shard specific rate limiter called outside MigrationSupport.doWithShard*")).shardId;
        MasterSlave masterSlave = MasterSlave.fromPolicy(MasterSlaveContextHolder.policy());
        HostKey key = new HostKey(shardId, masterSlave);

        if (!hasAvailableHosts(key) && masterSlave.isSlave()) {
            key = new HostKey(shardId, MasterSlave.MASTER);
        }

        return key;
    }
}
