package ru.yandex.chemodan.app.dataapi.core.ratelimiter.chunk.auto;

import java.util.concurrent.Semaphore;

import org.joda.time.Duration;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function;
import ru.yandex.bolts.function.Function0;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.core.dao.usermeta.UserMetaManagerWithSemaphore;
import ru.yandex.chemodan.ratelimiter.chunk.ChunkRateLimiter;
import ru.yandex.chemodan.ratelimiter.chunk.auto.AutoRwRateLimiter;
import ru.yandex.chemodan.ratelimiter.chunk.auto.AutoRwRateLimiterMapSupport;
import ru.yandex.chemodan.ratelimiter.chunk.auto.HostKey;
import ru.yandex.chemodan.ratelimiter.chunk.auto.MasterSlave;
import ru.yandex.chemodan.ratelimiter.chunk.auto.MetricsConfiguration;
import ru.yandex.chemodan.ratelimiter.chunk.auto.RateLimitersMetrics;
import ru.yandex.chemodan.util.sharpei.ShardUserInfo;
import ru.yandex.chemodan.util.yasm.monitor.YasmMonitor;
import ru.yandex.commune.db.shard2.ShardManager2;
import ru.yandex.misc.db.masterSlave.MasterSlaveContextHolder;

/**
 * @author yashunsky
 */
public class AutoUserAwareRwRateLimiter extends AutoRwRateLimiterMapSupport {
    private final UserMetaManagerWithSemaphore userMetaManager;
    private final Semaphore sharpeiSemaphore;

    public AutoUserAwareRwRateLimiter(ShardManager2 dataShardManager,
            UserMetaManagerWithSemaphore userMetaManager,
            Semaphore sharpeiSemaphore,
            YasmMonitor yasmMonitor,
            MetricsConfiguration metricsConfiguration,
            RateLimitersMetrics rateLimitersMetrics,
            Function0<Double> getInitialRateF,
            Function<Integer, Double> getMaxRateF,
            Function0<Double> getRateIncStepF,
            Function0<Double> getRateDecStepF,
            Function0<Double> getReadRateCoeffF,
            Function0<Double> getWriteRateCoeffF,
            Function0<Double> getMinUsageF,
            Function0<ListF<String>> getIgnoredHostsF,
            Function0<Boolean> getIsAutoEnabledF,
            Function0<Long> getMaxTimeSlotF,
            Function0<Option<Long>> getMaxAwaitTimeF,
            Function0<Integer> getDefaultChunkSizeF, Duration meterInterval,
            Duration averageInterval)
    {
        super(dataShardManager, yasmMonitor, metricsConfiguration, rateLimitersMetrics, getInitialRateF, getMaxRateF,
                getRateIncStepF, getRateDecStepF, getReadRateCoeffF, getWriteRateCoeffF, getMinUsageF, getIgnoredHostsF,
                getIsAutoEnabledF, getMaxTimeSlotF, getMaxAwaitTimeF, getDefaultChunkSizeF, meterInterval,
                averageInterval);
        this.userMetaManager = userMetaManager;
        this.sharpeiSemaphore = sharpeiSemaphore;
    }

    public AutoRwRateLimiter getRwRateLimiter(DataApiUserId uid) {
        return getOrElseAddLimiter(getHostKey(uid));
    }

    public ChunkRateLimiter getReadRateLimiter(DataApiUserId uid) {
        return getRwRateLimiter(uid).getReadRateLimiter();
    }

    public ChunkRateLimiter getReadRateLimiter(HostKey hostKey) {
        return getOrElseAddLimiter(hostKey).getReadRateLimiter();
    }

    public ChunkRateLimiter getWriteRateLimiter(DataApiUserId uid) {
        return getRwRateLimiter(uid).getWriteRateLimiter();
    }

    public ChunkRateLimiter getWriteRateLimiter(HostKey hostKey) {
        return getOrElseAddLimiter(hostKey).getWriteRateLimiter();
    }

    public HostKey getHostKey(DataApiUserId uid) {
        int shardId = userMetaManager.findMetaUser(uid, sharpeiSemaphore)
                .map(ShardUserInfo::getShardId).getOrThrow("No Shard found for user " + uid);

        MasterSlave masterSlave = MasterSlave.fromPolicy(MasterSlaveContextHolder.policy());
        HostKey key = new HostKey(shardId, masterSlave);

        if (!hasAvailableHosts(key) && masterSlave.isSlave()) {
            key = new HostKey(shardId, MasterSlave.MASTER);
        }

        return key;
    }

    public boolean hasAvailableHosts(DataApiUserId uid) {
        return hasAvailableHosts(getHostKey(uid));
    }

    public boolean hasAwaitingRequests(DataApiUserId uid) {
        return hasAwaitingRequests(getHostKey(uid));
    }
}
