package ru.yandex.chemodan.app.dataapi.core.xiva;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.dataapi.api.db.ref.external.ExternalDatabasesRegistry;
import ru.yandex.chemodan.app.dataapi.apps.settings.AppSettingsRegistry;
import ru.yandex.chemodan.app.dataapi.utils.xiva.XivaClientMultiplexed;

/**
 * @author akirakozov
 */
@Configuration
@Import(XivaContextConfiguration.class)
public class DataApiXivaContextConfiguration {

    @Bean
    public DataApiXivaPushSender dataApiXivaPushSender(
            XivaClientMultiplexed.SingleToken xivaPushClient,
            ExternalDatabasesRegistry externalDatabasesRegistry,
            AppSettingsRegistry appSettingsRegistry)
    {
        return new DataApiXivaPushSender(xivaPushClient, externalDatabasesRegistry, appSettingsRegistry);
    }

}
