package ru.yandex.chemodan.app.dataapi.core.xiva;

import java.util.Collection;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiPassportUserId;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.util.JsonAssert;
import ru.yandex.chemodan.xiva.XivaEvent;

import static ru.yandex.chemodan.app.dataapi.core.xiva.DataApiXivaPushSender.DATASYNC_DATABASE_CHANGED_EVENT;

public class DataApiXivaPushSenderCollapseKeyTest {

    @Test
    public void testSerializeXivaEventWithCollapseKey() {
        DataApiUserId uid = new DataApiPassportUserId(123L);
        Collection<String> tags = Cf.list("one", "two");
        long rev = 12345L;
        String aliasId = "alias@id";
        String contextString = "ctx";
        Option<String> collapseKey = Option.of("collapse@key");
        XivaEvent xivaEvent = new XivaEvent(DataApiXivaUtils.toXivaRecipient(uid), DATASYNC_DATABASE_CHANGED_EVENT)
                .addTags(tags)
                .withBody(new DataApiXivaPushSender.DatabaseChangedEventV2ForXiva(
                        DATASYNC_DATABASE_CHANGED_EVENT, rev, aliasId, contextString, collapseKey));

        JsonAssert.equalsLenient(getClass(), "xivaEventWithCollapseKey.json", xivaEvent.serializeBody());
    }

    @Test
    public void testSerializeXivaEventWithoutCollapseKey() {
        DataApiUserId uid = new DataApiPassportUserId(123L);
        Collection<String> tags = Cf.list("one", "two");
        long rev = 12345L;
        String aliasId = "alias@id";
        String contextString = "ctx";
        Option<String> collapseKey = Option.empty();
        XivaEvent xivaEvent = new XivaEvent(DataApiXivaUtils.toXivaRecipient(uid), DATASYNC_DATABASE_CHANGED_EVENT)
                .addTags(tags)
                .withBody(new DataApiXivaPushSender.DatabaseChangedEventV2ForXiva(
                        DATASYNC_DATABASE_CHANGED_EVENT, rev, aliasId, contextString, collapseKey));

        JsonAssert.equalsLenient(getClass(), "xivaEventWithoutCollapseKey.json", xivaEvent.serializeBody());

    }


}
