package ru.yandex.chemodan.app.dataapi.core.xiva;

import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.xiva.XivaEventRecipient;

/**
 * @author bursy
 */
public class DataApiXivaUtils {
    private static final String DISALLOWED_UID_SYMBOLS = "[^a-zA-Z0-9]+";

    public static boolean isUidSupportedForSending(DataApiUserId uid) {
        switch (uid.type) {
            case PUBLIC:
                return true;
            case PASSPORT:
            case YT:
                return uid.toPassportUidOrZero().getUid() != 0;
            default:
                return false;
        }
    }

    /**
     * Formats uid to xiva supported format, leaving only literals and digits
     * @param uid uid to format
     * @return formatted uid
     */
    public static XivaEventRecipient toXivaRecipient(DataApiUserId uid) {
        switch (uid.type) {
            case PASSPORT:
            case YT:
                return XivaEventRecipient.passport(uid.toPassportUid());

            case PUBLIC:
                return XivaEventRecipient.broadcast();

            default:
                return XivaEventRecipient.arbitrary(removeDisallowedUidSymbols(uid.toString()));
        }
    }

    private static String removeDisallowedUidSymbols(String value) {
        return value.replaceAll(DISALLOWED_UID_SYMBOLS, "");
    }
}
