package ru.yandex.chemodan.app.dataapi.core.xiva;

import org.junit.Test;

import ru.yandex.chemodan.app.dataapi.api.user.DataApiPassportUserId;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiYaTeamUserId;
import ru.yandex.chemodan.xiva.XivaEventRecipient;
import ru.yandex.misc.test.Assert;

/**
 * @author bursy
 */
public class DataApiXivaUtilsTest {

    @Test
    public void formatPassportUid() {
        DataApiUserId uid = new DataApiPassportUserId(123);
        Assert.equals(XivaEventRecipient.passport(123L), DataApiXivaUtils.toXivaRecipient(uid));
    }

    @Test
    public void formatYaTeamUid() {
        DataApiUserId uid = new DataApiYaTeamUserId(1120000000000001L);
        Assert.equals(XivaEventRecipient.passport(1120000000000001L), DataApiXivaUtils.toXivaRecipient(uid));
    }
}
