package ru.yandex.chemodan.app.dataapi.core.xiva;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

import ru.yandex.chemodan.app.dataapi.utils.xiva.XivaClientMultiplexed;
import ru.yandex.chemodan.util.spring.YaTeamQualifier;
import ru.yandex.chemodan.xiva.DiskXivaServices;
import ru.yandex.chemodan.xiva.XivaClient;
import ru.yandex.chemodan.xiva.XivaClientContextConfiguration;
import ru.yandex.chemodan.xiva.XivaSingleTokenClient;
import ru.yandex.chemodan.xiva.XivaYaTeamClientContextConfiguration;

/**
 * @author metal
 */
@Configuration
@Import({
        XivaClientContextConfiguration.class,
        XivaYaTeamClientContextConfiguration.class
})
public class XivaContextConfiguration {

    @Bean
    public XivaSingleTokenClient notifierXivaClient(XivaClient xivaClient) {
        return xivaClient.toSingleTokenClient(DiskXivaServices.DISK_NOTIFIER);
    }

    @Bean
    public XivaClientMultiplexed xivaClientMultiplexed(
            XivaClient publicClient,
            @YaTeamQualifier XivaClient yaTeamClient)
    {
        return new XivaClientMultiplexed(publicClient, yaTeamClient);
    }

    @Bean
    public XivaClientMultiplexed.SingleToken singleTokenXivaClientMultiplexed(XivaClientMultiplexed client) {
        return client.toSingleTokenClient(DiskXivaServices.DATASYNC, DiskXivaServices.DATASYNC_BROADCAST);
    }
}
