package ru.yandex.chemodan.app.dataapi.core.xiva;

import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.lang.StringUtils;
import ru.yandex.misc.test.Assert;

/**
 * @author metal
 */
public class XivaUrlGeneratingTestUtils {
    public static void assertUrlEquals(String expectedUrl, String url) {
        Assert.equals(getHostAndPath(expectedUrl), getHostAndPath(url));

        Tuple2List<String, String> expectedQueryParameters = getQueryParameters(getQuery(expectedUrl));
        Tuple2List<String, String> queryParameters = getQueryParameters(getQuery(url));
        Assert.sameSize(expectedQueryParameters, queryParameters);
        Assert.assertContainsAll(expectedQueryParameters, queryParameters);
    }

    private static Tuple2List<String, String> getQueryParameters(String url) {
        return UrlUtils.urlParametersToTuple2ListNoUrlDecode(url);
    }

    private static String getHostAndPath(String url) {
        return StringUtils.substringBefore(url, "?");
    }

    private static String getQuery(String url) {
        return StringUtils.substringAfter(url, "?");
    }
}
