package ru.yandex.chemodan.app.dataapi.core.xiva;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.function.Function2;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.xiva.XivaUtils;
import ru.yandex.misc.io.http.UrlUtils;
import ru.yandex.misc.lang.StringUtils;

/**
 * @author metal
 */
public class XivaUrlHelper {
    private final String xivaUrl;
    private final String xivaYaTeamUrl;

    public XivaUrlHelper(String xivaUrl, String xivaYaTeamUrl) {
        this.xivaUrl = xivaUrl;
        this.xivaYaTeamUrl = xivaYaTeamUrl;
    }

    public String getStreamSubscriptionUrl(Option<String> oauthToken, DataApiUserId uid,
            String client, String session,
            MapF<String, ListF<String>> servicesWithTags, Option<String> tld)
    {
        MapF<String, String> parameters = oauthToken.isPresent()
                ? Cf.<String, String>map().plus1("oauth_token", oauthToken.get())
                : Cf.map();
        parameters = parameters
                .plus1("uid", DataApiXivaUtils.toXivaRecipient(uid).getUrlValueO().get())
                .plus1("client", client)
                .plus1("session", session)
                .plus1("service", getServiceParameterForXivaSubscription(servicesWithTags));

        String xivaUrl = getXivaUrl(uid);

        tld = tld.map(s -> StringUtils.removeStart(s, "."));

        boolean replaceTld = xivaUrl.endsWith(".ru");
        if (tld.isPresent() && replaceTld) {
            xivaUrl = xivaUrl.substring(0, xivaUrl.length() - 3) + "." + tld.get();
        }

        return UrlUtils.addParameters(xivaUrl + "/v1/subscribe", parameters);
    }

    public String getApplicationSubscriptionUrl(Option<String> oauth, Option<String> client, String session,
            Option<String> deviceId, String platform, String platformPushToken,
            MapF<String, ListF<String>> servicesWithTags)
    {
        MapF<String, String> parameters = oauth.isPresent()
                        ? Cf.<String, String>map().plus1("oauth", oauth.get())
                        : Cf.<String, String>map().plus1("client", client.get()).plus1("deviceId", deviceId.get());
        parameters = parameters
                .plus1("platform", platform)
                .plus1("platform_push_token", platformPushToken)
                .plus1("session", session)
                .plus1("service", getServiceParameterForXivaSubscription(servicesWithTags));
        return UrlUtils.addParameters(xivaUrl + "/v1/subscribe/app", parameters);
    }

    public String getCallbackSubscriptionUrl(DataApiUserId uid, String xivaCtoken, String callback,
            String session, MapF<String, ListF<String>> servicesWithTags)
    {
        MapF<String, String> parameters = Cf.<String, String>map()
                .plus1("uid", DataApiXivaUtils.toXivaRecipient(uid).getUrlValueO().get())
                .plus1("ctoken", xivaCtoken)
                .plus1("callback", callback)
                .plus1("session", session)
                .plus1("service", getServiceParameterForXivaSubscription(servicesWithTags));
        return UrlUtils.addParameters(getXivaUrl(uid) + "/v1/subscribe/url", parameters);
    }

    private String getXivaUrl(DataApiUserId uid) {
        switch (uid.type) {
            case PASSPORT:
                return xivaUrl;
            case YT:
                return xivaYaTeamUrl;
            default:
                throw new IllegalArgumentException("UID type " + uid.type + " is not supported");
        }
    }

    private static String getServiceParameterForXivaSubscription(MapF<String, ListF<String>> servicesWithTags) {
        ListF<String> servicesWithTagsAsStrings = servicesWithTags.entries().map(getServiceWithTagsF());
        return StringUtils.join(servicesWithTagsAsStrings, ",");
    }

    private static Function2<String, ListF<String>, String> getServiceWithTagsF() {
        return (service, tags) -> service +
                (tags.isEmpty() ? "" : ":") +
                StringUtils.join(tags.map(XivaUtils::formatTag), "+");
    }
}
