package ru.yandex.chemodan.app.dataapi.maintenance;

import java.util.Optional;
import java.util.concurrent.ThreadFactory;

import org.joda.time.Duration;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

import ru.yandex.chemodan.app.dataapi.core.datasources.disk.DiskDataSource;
import ru.yandex.chemodan.app.dataapi.core.datasources.ydb.YdbDataSource;
import ru.yandex.chemodan.app.dataapi.core.mdssnapshot.MdsSnapshotReferenceManager;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.commune.db.shard2.ShardManager2;
import ru.yandex.commune.dynproperties.DynamicProperty;
import ru.yandex.misc.thread.factory.ThreadNameIndexThreadFactory;

/**
 * @author dbrylev
 */
@Configuration
public class DatabasesTasksContextConfiguration {

    private final DynamicProperty<Boolean> parallelDeleteOldSnapshotReferenceEnabled =
            new DynamicProperty<>("dataapi-delete-old-snapshot-reference-parallel-enabled", false);

    private final DynamicProperty<Integer> parallelDeleteOldSnapshotReferenceThreadCount =
            new DynamicProperty<>("dataapi-delete-old-snapshot-reference-parallel-thread-count", 5);

    @Bean
    public DeleteOldSnapshotReferencesCronTask deleteOldSnapshotReferencesCronTask(
            @Value("${dataapi.snapshot.deletion-task.execution-period}")
            Duration executionPeriod,
            @Value("${dataapi.snapshot.deletion-task.timeout}")
            Duration timeout,
            MdsSnapshotReferenceManager mdsSnapshotReferenceManager, @Qualifier("dataShardManager") ShardManager2 dataShardManager,
            BazingaTaskManager bazingaTaskManager)
    {
        return new DeleteOldSnapshotReferencesCronTask(executionPeriod, timeout, mdsSnapshotReferenceManager,
                parallelDeleteOldSnapshotReferenceEnabled::get, dataShardManager, bazingaTaskManager,
                DeleteOldSnapshotReferenceByShardTask::new);
    }

    @Bean
    public PurgeDeletedDatabasesCronTask purgeDeletedDatabasesCronTask(
            @Value("${dataapi.databases.purge-deleted-task.database-ttl}")
            Duration databaseTtl,
            @Value("${dataapi.databases.purge-deleted-task.execution-period}")
            Duration period,
            @Value("${dataapi.databases.purge-deleted-task.execution-timeout}")
            Duration timeout,
            DiskDataSource dataApiManager, Optional<YdbDataSource> ydbDataSource)
    {
        return new PurgeDeletedDatabasesCronTask(databaseTtl, period, timeout, dataApiManager, ydbDataSource);
    }

    @Bean
    public ThreadFactory deleteSnapshotsThreadFactory() {
        return new ThreadNameIndexThreadFactory("dataapi-delete-old-snapshot-reference");
    }

    @Bean
    public DeleteOldSnapshotReferenceByShardTask deleteOldSnapshotReferenceByShardTask(@Qualifier("dataShardManager") ShardManager2 dataShardManager,
                                                                                       MdsSnapshotReferenceManager mdsSnapshotReferenceManager,
                                                                                       ThreadFactory deleteSnapshotsThreadFactory)
    {
        return new DeleteOldSnapshotReferenceByShardTask(mdsSnapshotReferenceManager, dataShardManager,
                parallelDeleteOldSnapshotReferenceThreadCount::get, deleteSnapshotsThreadFactory);
    }
}
