package ru.yandex.chemodan.app.dataapi.maintenance;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Supplier;

import lombok.Data;
import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.core.mdssnapshot.MdsSnapshotReferenceManager;
import ru.yandex.chemodan.app.dataapi.worker.DataApiTaskQueueName;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.OnetimeTaskSupport;
import ru.yandex.commune.bazinga.scheduler.TaskQueueName;
import ru.yandex.commune.db.shard2.Shard2;
import ru.yandex.commune.db.shard2.ShardManager2;
import ru.yandex.misc.bender.annotation.BenderBindAllFields;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

public class DeleteOldSnapshotReferenceByShardTask extends OnetimeTaskSupport<DeleteOldSnapshotReferenceByShardTask.Parameters> {

    private static final Logger logger = LoggerFactory.getLogger(DeleteOldSnapshotReferenceByShardTask.class);

    private MdsSnapshotReferenceManager mdsSnapshotReferenceManager;

    private ShardManager2 shardManager;

    private Supplier<Integer> threadsCountProvider;

    private ThreadFactory threadFactory;

    public DeleteOldSnapshotReferenceByShardTask(MdsSnapshotReferenceManager mdsSnapshotReferenceManager,
                                                 ShardManager2 shardManager, Supplier<Integer> threadsCountProvider,
                                                 ThreadFactory threadFactory)
    {
        super(Parameters.class);
        this.mdsSnapshotReferenceManager = mdsSnapshotReferenceManager;
        this.shardManager = shardManager;
        this.threadsCountProvider = threadsCountProvider;
        this.threadFactory = threadFactory;
    }

    public DeleteOldSnapshotReferenceByShardTask(Parameters parameters) {
        super(parameters);
    }

    @Override
    protected void execute(Parameters parameters, ExecutionContext context) throws Exception {
        deleteOldSnapshotReferences(parameters);
    }

    @Override
    public int priority() {
        return 0;
    }

    @Override
    public Duration timeout() {
        return Duration.standardHours(12);
    }

    @Override
    public TaskQueueName queueName() {
        return DataApiTaskQueueName.DATAAPI_REGULAR;
    }

    public void deleteOldSnapshotReferences(Parameters parameters) {
        Option<Shard2> shardO = shardManager.shards().find(shard -> parameters.getShard().equals(shard.getShardInfo().getName()));
        if (!shardO.isPresent()) {
            logger.info("Shard '{}' has not been found");
            return;
        }
        int threadCount = threadsCountProvider.get();
        ExecutorService executor = Executors.newFixedThreadPool(threadCount, threadFactory);
        mdsSnapshotReferenceManager.deleteOldSnapshotReferencesByShardParallel(shardO.get(), executor, threadCount,
                Option.of(new Instant(parameters.getTimeToCheck())));
        executor.shutdown();
    }

    @Data
    @BenderBindAllFields
    public static class Parameters {

        private final String shard;

        private final long timeToCheck;
    }
}
