package ru.yandex.chemodan.app.dataapi.maintenance;

import java.util.function.Supplier;

import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.dataapi.core.mdssnapshot.MdsSnapshotReferenceManager;
import ru.yandex.chemodan.app.dataapi.worker.DataApiCronTask;
import ru.yandex.commune.bazinga.BazingaTaskManager;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.SchedulePeriodic;
import ru.yandex.commune.db.shard2.ShardManager2;
import ru.yandex.commune.util.RetryUtils;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;

/**
 * @author Denis Bakharev
 */
public class DeleteOldSnapshotReferencesCronTask extends DataApiCronTask {

    private final static Logger logger = LoggerFactory.getLogger(DeleteOldSnapshotReferencesCronTask.class);

    private final Duration period;
    private final Duration timeout;
    private final MdsSnapshotReferenceManager mdsSnapshotReferenceManager;
    private final Supplier<Boolean> parallelModeEnabled;
    private final ShardManager2 shardManager;
    private final BazingaTaskManager bazingaTaskManager;
    private final Function<DeleteOldSnapshotReferenceByShardTask.Parameters, ? extends DeleteOldSnapshotReferenceByShardTask> tasksProvider;

    public DeleteOldSnapshotReferencesCronTask(
            Duration period, Duration timeout, MdsSnapshotReferenceManager mdsSnapshotReferenceManager,
            Supplier<Boolean> parallelModeEnabled, ShardManager2 shardManager, BazingaTaskManager bazingaTaskManager,
            Function<DeleteOldSnapshotReferenceByShardTask.Parameters, ? extends DeleteOldSnapshotReferenceByShardTask> tasksProvider)
    {
        this.period = period;
        this.timeout = timeout;
        this.mdsSnapshotReferenceManager = mdsSnapshotReferenceManager;
        this.parallelModeEnabled = parallelModeEnabled;
        this.shardManager = shardManager;
        this.bazingaTaskManager = bazingaTaskManager;
        this.tasksProvider = tasksProvider;
    }

    @Override
    public Duration timeout() {
        return timeout;
    }

    @Override
    public Schedule cronExpression() {
        return new SchedulePeriodic(period);
    }

    @Override
    public void execute(ExecutionContext executionContext) throws Exception {
        if (parallelModeEnabled.get()) {
            shardManager.shards().forEach(shard -> RetryUtils.retry(logger, 3, () ->
                    bazingaTaskManager.schedule(tasksProvider.apply(
                            new DeleteOldSnapshotReferenceByShardTask.Parameters(
                                    shard.getShardInfo().getName(),
                                    Instant.now().getMillis()
                            )
                    ))));
            return;
        }
        mdsSnapshotReferenceManager.deleteOldSnapshotReferences();
    }
}
