package ru.yandex.chemodan.app.dataapi.maintenance;

import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.DataApiBenderUtils;
import ru.yandex.chemodan.app.dataapi.api.data.record.DataRecord;
import ru.yandex.chemodan.app.dataapi.api.db.Database;
import ru.yandex.chemodan.app.dataapi.api.user.DataApiUserId;
import ru.yandex.chemodan.app.dataapi.core.dao.data.DataRecordsJdbcDao;
import ru.yandex.chemodan.app.dataapi.core.datasources.disk.DiskDataSource;
import ru.yandex.commune.db.partition.PartitionResolver;
import ru.yandex.commune.db.shard2.ShardManager2;
import ru.yandex.misc.bender.BenderMapper;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.spring.jdbc.JdbcTemplate3;


/**
 * @author metal
 */
public class ProtobufToJsonbMigrationManager {
    private static final Logger logger = LoggerFactory.getLogger(ProtobufToJsonbMigrationManager.class);

    private static final BenderMapper mapper = DataApiBenderUtils.mapper();

    @Autowired
    private DiskDataSource dataApiManager;

    @Autowired
    private DataRecordsJdbcDao dataRecordsDao;

    @Autowired
    private ShardManager2 dataShardManager;

    @Autowired
    private PartitionResolver partitionResolver;

    public void migrate() {
        migrate(true);
    }

    public void migrateFromStartUserIndex(int startUserIndex) {
        migrateFromStartUserIndex(true, startUserIndex);
    }

    public void migrateSpecificUsers(ListF<String> users) {
        migrateSpecificUsers(true, users);
    }

    public void migrate(boolean migrateToJsonb) {
        migrateFromStartUserIndex(migrateToJsonb, 0);
    }

    public void migrateFromStartUserIndex(boolean migrateToJsonb, int startUserIndex) {
        JdbcTemplate3 jdbcTemplate = dataShardManager.getShard(1).getJdbcTemplate3();
        ListF<DataApiUserId> users = Cf.arrayList();
        for (int i = 1; i <= 128; i++) {
            String table = partitionResolver.partitionTableNameForDiscriminant("databases", i);
            String q = "SELECT distinct(user_id) from " + table + " WHERE records_count > 0";
            users.addAll(jdbcTemplate.queryForList(q, String.class).map(DataApiUserId::parse));
        }

        migrateUsers(migrateToJsonb, startUserIndex, users);
    }

    public void migrateSpecificUsers(boolean migrateToJsonb, ListF<String> users) {
        migrateUsers(migrateToJsonb, 0, users.map(DataApiUserId::parse));
    }

    private void migrateUsers(boolean migrateToJsonb, int startUserIndex, ListF<DataApiUserId> users) {
        String type = migrateToJsonb ? "jsonb" : "protobuf";

        logger.info("Migration to " + type + " started for " + (users.size() - startUserIndex) + " users");

        for (int i = startUserIndex; i < users.size(); i++) {
            DataApiUserId uid = users.get(i);

            logger.info("Migrating to " + type + " started for user with index " + i + " and uid " + uid.toString());
            try {
                for (Database database : dataApiManager.listDatabases(uid)) {
                    for (DataRecord record : dataRecordsDao.find(uid, database.dbHandle)) {
                        dataRecordsDao.updateContentsWithRevisionCheck(uid, database.dbRef(), record,
                                migrateToJsonb);
                    }
                }
                logger.info("Migrating to " + type + " finished for user with index " + i + " and uid " + uid.toString());
            } catch (Exception e) {
                logger.error("Migrating to " + type + " failed for user with index " + i + " and uid " + uid.toString(), e);
            }
        }

        logger.info("Migration to " + type + " finished");
    }
}
