package ru.yandex.chemodan.app.dataapi.maintenance;

import java.util.Optional;

import org.joda.time.Duration;
import org.joda.time.Instant;

import ru.yandex.chemodan.app.dataapi.core.datasources.disk.DiskDataSource;
import ru.yandex.chemodan.app.dataapi.core.datasources.ydb.YdbDataSource;
import ru.yandex.chemodan.app.dataapi.worker.DataApiCronTask;
import ru.yandex.commune.bazinga.scheduler.ExecutionContext;
import ru.yandex.commune.bazinga.scheduler.schedule.Schedule;
import ru.yandex.commune.bazinga.scheduler.schedule.SchedulePeriodic;

/**
 * @author dbrylev
 */
public class PurgeDeletedDatabasesCronTask extends DataApiCronTask {

    private final Duration databaseTtl;
    private final Duration period;
    private final Duration timeout;

    private final DiskDataSource diskDataSource;
    private final Optional<YdbDataSource> ydbDataSource;

    public PurgeDeletedDatabasesCronTask(
            Duration databaseTtl,
            Duration period, Duration timeout,
            DiskDataSource diskDataSource,
            Optional<YdbDataSource> ydbDataSource)
    {
        this.databaseTtl = databaseTtl;
        this.period = period;
        this.timeout = timeout;
        this.diskDataSource = diskDataSource;
        this.ydbDataSource = ydbDataSource;
    }

    @Override
    public void execute(ExecutionContext executionContext) throws Exception {
        diskDataSource.completelyRemoveDatabasesDeletedBefore(Instant.now().minus(databaseTtl));
        ydbDataSource.ifPresent(ds -> ds.completelyRemoveDatabasesDeletedBefore(Instant.now().minus(databaseTtl)));
    }

    @Override
    public Duration timeout() {
        return timeout;
    }

    @Override
    public Schedule cronExpression() {
        return new SchedulePeriodic(period);
    }
}
