package ru.yandex.chemodan.app.dataapi.support;

import java.util.EnumMap;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.inside.utils.Language;

/**
 * @author dbrylev
 */
public class I18nRecordField<T> {

    private final RecordField<T> baseField;
    private final MapF<Language, String> i18nNames;

    public I18nRecordField(RecordField<T> baseField) {
        this.baseField = baseField;
        this.i18nNames = Cf.x(new EnumMap<>(Language.R.valuesList()
                .toMapMappingToValue(lang -> baseField.name + "_" + lang.value())));
    }

    public static I18nRecordField<String> string(String name) {
        return new I18nRecordField<>(RecordField.string(name));
    }

    public Tuple2List<String, DataField> toData(I18nValue<T> value) {
        return Tuple2List.<String, DataField>tuple2List()
                .plus(value.base.map(baseField::toData))
                .plus(value.translations.mapEntries(
                        (lang, val) -> Tuple2.tuple(i18nNames.getTs(lang), baseField.toF.apply(val))));
    }

    public I18nValue<T> get(MapF<String, DataField> data) {
        Option<T> base = baseField.getO(data);

        MapF<Language, T> translations = i18nNames.entrySet()
                .filterMap(e -> data.getO(e.getValue()).map(v -> Tuple2.tuple(e.getKey(), baseField.fromF.apply(v))))
                .toMap(Tuple2::get1, Tuple2::get2);

        return new I18nValue<T>(base, translations);
    }

    public Tuple2List<String, T> entries(MapF<String, DataField> data) {
        return Cf.list(baseField.name).plus(i18nNames.values())
                .zipWithFlatMapO(name -> data.getO(name).map(baseField.fromF));
    }

    public I18nValue<T> get(DataFieldsSource src) {
        return get(src.toData());
    }

    public Tuple2List<String, T> entries(DataFieldsSource src) {
        return entries(src.toData());
    }
}
