package ru.yandex.chemodan.app.dataapi.support;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.inside.utils.Language;
import ru.yandex.misc.test.Assert;

/**
 * @author dbrylev
 */
public class I18nRecordFieldTest {

    @Test
    public void toData() {
        I18nRecordField<String> field = I18nRecordField.string("field");

        Assert.equals(
                Tuple2List.fromPairs("field", DataField.string("base"), "field_ru", DataField.string("база")),
                field.toData(new I18nValue<>("base", Cf.map(Language.RUSSIAN, "база"))));
    }

    @Test
    public void getData() {
        I18nRecordField<String> field = I18nRecordField.string("field");

        I18nValue<String> value = field.get(Cf.toMap(Tuple2List.fromPairs(
                "field", DataField.string("base"),
                "field_ru", DataField.string("база"),
                "field-ru", DataField.string("-"))));

        Assert.some("base", value.base);
        Assert.equals(Cf.map(Language.RUSSIAN, "база"), value.translations);

        Assert.none(field.get(Cf.map()).base);
        Assert.isEmpty(field.get(Cf.map()).translations);
    }
}
