package ru.yandex.chemodan.app.dataapi.support;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.Tuple2List;
import ru.yandex.inside.utils.Language;
import ru.yandex.inside.utils.LocalizedString;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author dbrylev
 */
public class I18nValue<T> extends DefaultObject {

    public final Option<T> base;
    public final MapF<Language, T> translations;

    public I18nValue(T base) {
        this(base, Cf.map());
    }

    public I18nValue(T base, MapF<Language, T> translations) {
        this(Option.of(base), translations);
    }

    public I18nValue(T ru, T en, T uk, T tr) {
        this(Cf.toMap(Tuple2List.fromPairs(
                Language.RUSSIAN, ru,
                Language.ENGLISH, en,
                Language.UKRAINIAN, uk,
                Language.TURKISH, tr)));
    }

    public I18nValue(MapF<Language, T> translations) {
        this(Option.empty(), translations);
    }

    public I18nValue(Option<T> base, MapF<Language, T> translations) {
        this.base = base;
        this.translations = translations;
    }

    public static I18nValue<String> of(LocalizedString string) {
        return new I18nValue<>(Option.empty(), string.getAll());
    }
}
