package ru.yandex.chemodan.app.dataapi.support;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.DataApiBenderUtils;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataFields;
import ru.yandex.misc.bender.BenderParserSerializer;
import ru.yandex.misc.enums.StringEnum;
import ru.yandex.misc.test.Assert;

/**
 * @author dbrylev
 */
public class RecordFieldTest {

    @Test
    public void listOfLists() {
        RecordField<ListF<ListF<Integer>>> field = RecordField.list(RecordField.list(RecordField.intNumber("numbers")));

        ListF<ListF<Integer>> value = Cf.list(Cf.list(1, 2), Cf.list(), Cf.list(3));

        BenderParserSerializer<DataFields> ps = DataApiBenderUtils.mapper().createParserSerializer(DataFields.class);

        DataFields parsed = ps.getParser().parseJson(ps.getSerializer().serializeJson(
                new DataFields(Cf.toMap(Cf.list(field.toData(value))))));

        Assert.equals(value, field.get(parsed.data()));
    }

    @Test
    public void stringEnumValueMismatch() {
        RecordField<TestEnum> field = RecordField.stringEnum("", TestEnum.class);

        Assert.equals(TestEnum.IN_JAVA_WE_LOVE_LONG_IDENTIFIERS, field.get(Cf.map("", DataField.string("db_id"))));
        Assert.equals("db_id", field.toData(TestEnum.IN_JAVA_WE_LOVE_LONG_IDENTIFIERS).get2().stringValue());
    }

    enum TestEnum implements StringEnum {
        IN_JAVA_WE_LOVE_LONG_IDENTIFIERS("db_id");

        private final String value;

        TestEnum(String value) {
            this.value = value;
        }

        @Override
        public String value() {
            return value;
        }
    }
}
