package ru.yandex.chemodan.app.dataapi.support;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.bolts.collection.SetF;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.deltas.FieldChange;
import ru.yandex.misc.reflection.ClassX;

/**
 * @author dbrylev
 */
public class RecordFieldUtils {

    public static SetF<String> fieldNames(Class<?> holder) {
        return ClassX.wrap(holder)
                .getStaticFieldsOfType(RecordField.class)
                .map(f -> ((RecordField) f.getStatic()).name)
                .unique();
    }

    public static ListF<FieldChange> diff(MapF<String, DataField> stale, MapF<String, DataField> fresh) {
        ListF<FieldChange> deleted = stale.keySet()
                .filterNot(fresh::containsKeyTs).map(FieldChange::delete);

        ListF<FieldChange> changed = fresh.keySet()
                .filterMap(key -> Option.when(
                        !stale.getO(key).exists(fresh.getTs(key)::equals),
                        FieldChange.put(key, fresh.getTs(key))));

        return deleted.plus(changed);
    }
}
