package ru.yandex.chemodan.app.dataapi.support;

import org.junit.Test;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.api.deltas.FieldChange;
import ru.yandex.misc.test.Assert;

/**
 * @author dbrylev
 */
public class RecordFieldUtilsTest {

    @Test
    public void diffToNull() {
        ListF<FieldChange> changes;

        changes = RecordFieldUtils.diff(Cf.map("key", DataField.string("value")), Cf.map("key", DataField.nul()));
        Assert.equals(FieldChange.put("key", DataField.nul()), changes.single());

        changes = RecordFieldUtils.diff(Cf.map(), Cf.map("key", DataField.nul()));
        Assert.equals(FieldChange.put("key", DataField.nul()), changes.single());

        changes = RecordFieldUtils.diff(Cf.map("key", DataField.string("value")), Cf.map());
        Assert.equals(FieldChange.delete("key"), changes.single());
    }
}
