package ru.yandex.chemodan.app.dataapi.utils;

import ru.yandex.bolts.collection.CollectionF;
import ru.yandex.bolts.function.Function;
import ru.yandex.chemodan.app.dataapi.DataApiBenderUtils;
import ru.yandex.commune.zk2.ZkPath;
import ru.yandex.commune.zk2.primitives.registry.ZkPathEscaping;
import ru.yandex.commune.zk2.primitives.registry.ZkRegistry;
import ru.yandex.misc.bender.Bender;

/**
 * @author Dmitriy Amelin (lemeh)
 */
public abstract class DataApiZkRegistry<TDataNode> extends ZkRegistry<String, TDataNode> {

    public DataApiZkRegistry(
            ZkPath zkPath, Class<TDataNode> elementClass,
            Function<TDataNode, String> idF, ZkPathEscaping escaping)
    {
        super(zkPath, Bender.cons(elementClass, DataApiBenderUtils.getConfig()), idF, s -> s, escaping);
        super.addListener(this::handleNewState);
    }

    protected void handleNewState(CollectionF<TDataNode> elements) {}
}
