package ru.yandex.chemodan.app.dataapi.utils;

import ru.yandex.commune.a3.action.http.HttpStatusCodeSource;
import ru.yandex.commune.a3.action.result.error.ErrorLogLevelSource;
import ru.yandex.misc.io.http.HttpStatus;
import ru.yandex.misc.log.mlf.Level;

public interface HttpStatusCodeSourceWithErrorLevel extends HttpStatusCodeSource, ErrorLogLevelSource {

    default Level getErrorLogLevel() {
        if (HttpStatus.is5xx(getHttpStatusCode())){
            return Level.ERROR;
        }
        return Level.WARN;
    }
}
