package ru.yandex.chemodan.app.dataapi.utils;

import ru.yandex.bolts.function.Function0V;
import ru.yandex.chemodan.app.dataapi.core.DataApiStats;
import ru.yandex.commune.a3.utils.Ordered;
import ru.yandex.misc.lang.DefaultObject;
import ru.yandex.misc.log.mlf.Logger;
import ru.yandex.misc.log.mlf.LoggerFactory;
import ru.yandex.misc.monica.core.blocks.UpdateMode;
import ru.yandex.misc.monica.core.name.MetricName;

/**
 * Runnable with priority and metrics
 * @author vpronto
 */
public class PriorityRunnable extends DefaultObject implements Runnable, Ordered {

    private static final Logger logger = LoggerFactory.getLogger(PriorityRunnable.class);

    private final Function0V runnable;
    private final String metricName;
    private final int order;

    public PriorityRunnable(Function0V runnable, String metricName, int order) {
        this.runnable = runnable;
        this.metricName = metricName;
        this.order = order;
    }

    @Override
    public void run() {
        try {
            DataApiStats.listenerInvocations.measure(runnable, new MetricName(metricName), UpdateMode.RECURSIVE);
        } catch (Exception e) {
            logger.error("Error in async execution {}", toString(), e);
        }
    }

    @Override
    public int getOrder() {
        return order;
    }

}
