package ru.yandex.chemodan.app.dataapi.utils;

import net.spy.memcached.CachedData;
import net.spy.memcached.transcoders.Transcoder;

import ru.yandex.commune.protobuf5.Protobuf5Serializer;

/**
 * @author Denis Bakharev
 */
public class ProtobufTranscoder<T> implements Transcoder<T> {
    private final Protobuf5Serializer<T> serializer;

    public ProtobufTranscoder(Class<T> clazz) {
        serializer = Protobuf5Serializer.cons(clazz);
    }

    @Override
    public boolean asyncDecode(CachedData d) {
        return false;
    }

    @Override
    public CachedData encode(T o) {
        return new CachedData(0, serializer.serialize(o), CachedData.MAX_SIZE);
    }

    @Override
    public T decode(CachedData d) {
        return serializer.deserialize(d.getData());
    }

    @Override
    public int getMaxSize() {
        return CachedData.MAX_SIZE;
    }
}
