package ru.yandex.chemodan.app.dataapi.utils;

import org.joda.time.DateTime;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.context.DatabaseContext;
import ru.yandex.chemodan.app.dataapi.api.data.record.CollectionRef;
import ru.yandex.chemodan.app.dataapi.api.db.ref.DatabaseRef;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.misc.env.EnvironmentType;

/**
 * @author metal
 */
public class YtPathsUtils {
    private static final ListF<EnvironmentType> TESTING_ENVIRONMENTS =
            Cf.list(EnvironmentType.TESTS, EnvironmentType.TESTING, EnvironmentType.DEVELOPMENT);

    public static final DateTimeFormatter YT_NODE_NAME_FORMATTER = DateTimeFormat.forPattern("yyyy-MM-dd");
    public static final String CURRENT_DUMP_NAME = "current";
    private static final String MERGE_SCRIPT_RELATIVE_PATH = "scripts/merge_dump_and_logs.py";
    private static final String DELTAS_CLEANING_PATH = "deltasCleaning";

    public static YPath getMergeScriptYPath() {
        return YPath.simple(getDataSyncHomeFolderPath() + MERGE_SCRIPT_RELATIVE_PATH);
    }

    public static YPath getDeltasCleaningYPath() {
        return YPath.simple(getDataSyncHomeFolderPath() + DELTAS_CLEANING_PATH);
    }

    public static YPath getImportsResultsYPath(String typeName, String importId) {
        return getHomeYPath(Cf.list("imports/results", typeName, importId).mkString("/"));
    }

    public static YPath getProperYPathForCurrentDump(YPath dumpFolder) {
        return dumpFolder.child(CURRENT_DUMP_NAME);
    }

    public static YPath getProperYPathWithDate(String prefix, DatabaseRef dbRef, Option<String> collectionId) {
        return YPath.simple(getProperYPath(prefix, dbRef, collectionId) + "/" + YT_NODE_NAME_FORMATTER.print(DateTime.now()));
    }

    public static YPath getProperYPath(String prefix, CollectionRef collectionRef) {
        return getProperYPath(prefix, collectionRef.dbRef(), Option.of(collectionRef.collectionId));
    }

    public static YPath getProperYPath(String prefix, DatabaseRef dbRef, Option<String> collectionId) {
        String path = getDataSyncHomeFolderPath() + prefix + "/";
        String collectionIdPart = collectionId.isPresent() ? "/" + collectionId.get() : "";
        String appId = dbRef.dbAppId();
        appId = appId.equals(DatabaseContext.global().dbAppId()) ? "global" : appId;
        path = path
                + appId
                + "/" + dbRef.databaseId()
                + collectionIdPart;
        return YPath.simple(path);
    }

    public static YPath getHomeYPath(String subpath) {
        return YPath.simple(getDataSyncHomeFolderPath() + subpath);
    }

    private static String addTestingFolderIfNeeded(String path) {
        return EnvironmentType.getActive() == EnvironmentType.PRESTABLE ? path + "testing/" : path;
    }

    private static String getDataSyncHomeFolderPath() {
        return addTestingFolderIfNeeded(
                isTestingEnvironment(EnvironmentType.getActive())
                        ? "//home/datasync-api/"
                        : "//home/datasync/");
    }

    private static boolean isTestingEnvironment(EnvironmentType activeEnvironment) {
        return TESTING_ENVIRONMENTS.containsTs(activeEnvironment);
    }
}
