package ru.yandex.chemodan.app.dataapi.utils;

import org.joda.time.DateTime;
import org.junit.Test;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.api.data.record.CollectionRef;
import ru.yandex.chemodan.app.dataapi.api.db.ref.AppDatabaseRef;
import ru.yandex.inside.yt.kosher.cypress.YPath;
import ru.yandex.misc.test.Assert;

import static ru.yandex.chemodan.app.dataapi.utils.YtPathsUtils.YT_NODE_NAME_FORMATTER;

/**
 * @author metal
 */
public class YtPathsUtilsTest {
    private static String PATH = "//home/datasync-api/superprefix/app_id/db_id";
    private static String PATH_WITH_COLLECTION = PATH + "/coll_id";

    @Test
    public void properYPathTest() {
        YPath path = YtPathsUtils.getProperYPath("superprefix", new AppDatabaseRef("app_id", "db_id"), Option.empty());
        Assert.equals(YPath.simple(PATH), path);

        path = YtPathsUtils.getProperYPathForCurrentDump(YPath.simple(PATH_WITH_COLLECTION));
        Assert.equals(YPath.simple(PATH_WITH_COLLECTION + "/" + YtPathsUtils.CURRENT_DUMP_NAME), path);

        path = YtPathsUtils.getProperYPath("superprefix", new AppDatabaseRef("app_id", "db_id"), Option.of("coll_id"));
        Assert.equals(YPath.simple(PATH_WITH_COLLECTION), path);

        path = YtPathsUtils.getProperYPath("superprefix", CollectionRef.cons(new AppDatabaseRef("app_id", "db_id"), "coll_id"));
        Assert.equals(YPath.simple(PATH_WITH_COLLECTION), path);

        path = YtPathsUtils.getProperYPathWithDate("superprefix", new AppDatabaseRef("app_id", "db_id"), Option.empty());
        Assert.equals(YPath.simple(PATH + "/" + YT_NODE_NAME_FORMATTER.print(DateTime.now())), path);

        path = YtPathsUtils.getProperYPathWithDate("superprefix", new AppDatabaseRef("app_id", "db_id"), Option.of("coll_id"));
        Assert.equals(YPath.simple(PATH_WITH_COLLECTION + "/" + YT_NODE_NAME_FORMATTER.print(DateTime.now())), path);
    }

    @Test
    public void properGlobalDbTest() {
        YPath path = YtPathsUtils.getProperYPath(
                "superprefix", new AppDatabaseRef(".@$GLOBAL", "db_id"), Option.of("coll_id"));
        Assert.equals(YPath.simple("//home/datasync-api/superprefix/global/db_id/coll_id"), path);
    }
}
