package ru.yandex.chemodan.app.dataapi.utils.dataconversion;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.dataapi.utils.dataconversion.typeconverters.TypeConverter;
import ru.yandex.misc.bender.parse.BenderJsonNode;
import ru.yandex.misc.bender.serialize.BenderJsonWriter;
import ru.yandex.misc.lang.Check;

/**
 * @author Denis Bakharev
 */
public abstract class AbstractConverter<TWriter extends BenderJsonWriter, TNode extends BenderJsonNode> {
    private final MapF<String, TypeConverter> typeConverters;
    public final TWriter writer;

    public AbstractConverter(MapF<String, TypeConverter> typeConverters, TWriter writer) {
        this.typeConverters = typeConverters;
        this.writer = writer;
    }

    public void convert(ConverterContext<TNode> context) {
        TypeConverter typeConverter = getTypeConverter(context);
        if((context.dataNode == null || context.dataNode.isNull()) && typeConverter.isIgnoreNullDataNodes()) {
            return;
        }

        convert(typeConverter, context);
    }

    protected abstract void convert(TypeConverter converter, ConverterContext<TNode> context);

    private TypeConverter getTypeConverter(ConverterContext<TNode> context) {
        String typeName = context.settings.getActualType();

        Check.isTrue(typeConverters.containsKeyTs(typeName), "can't find converter for type " + typeName);

        return typeConverters.getTs(typeName);
    }
}
