package ru.yandex.chemodan.app.dataapi.utils.dataconversion;

import java.util.Iterator;

import com.fasterxml.jackson.databind.JsonNode;

import ru.yandex.bolts.collection.Cf;
import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.util.json.JsonNodeUtils;
import ru.yandex.misc.lang.Check;
import ru.yandex.misc.lang.Validate;

/**
 * @author Denis Bakharev
 */
public class ConversionSettingsLoader {
    public static NodeConversionSettings loadFromJsonSchema(String jsonSchema)  {
        JsonNode schemaRootNode = JsonNodeUtils.getNode(jsonSchema);
        NodeConversionSettings result = doDfs(schemaRootNode, "");
        return result;
    }

    private static NodeConversionSettings doDfs(JsonNode node, String nodeName) {
        Validate.notNull(node);

        JsonNode typeNode = node.get("type");

        ListF<NodeConversionSettings> childrenSettings = Cf.arrayList();

        String nodeTypeString = typeNode.asText();
        if (nodeTypeString.equals("object")) {
            childrenSettings.addAll(readObjectRecursively(node));
        } else if (nodeTypeString.equals("array")) {
            childrenSettings.add(readArrayRecursively(node));
        }

        NodeConversionSettings settings = new NodeConversionSettings(
                nodeName,
                Cf.list(childrenSettings),
                nodeTypeString,
                getDataApiType(node));

        return settings;
    }

    private static NodeConversionSettings readArrayRecursively(JsonNode node) {
        JsonNode itemsNode = node.get("items");

        Check.equals(1, itemsNode.size(), "Поддерживаем только один тип элемента в массиве");
        NodeConversionSettings result = doDfs(itemsNode.get(0), Integer.toString(0));
        return result;
    }

    private static ListF<NodeConversionSettings> readObjectRecursively(JsonNode node) {
        ListF<NodeConversionSettings> result = Cf.arrayList();
        JsonNode propertiesNode = node.get("properties");
        Iterator<String> names = propertiesNode.fieldNames();
        while (names.hasNext()) {
            String propertyName = names.next();
            NodeConversionSettings propertySettings = doDfs(propertiesNode.get(propertyName), propertyName);
            result.addAll(propertySettings);
        }

        return result;
    }

    private static Option<String> getDataApiType(JsonNode node) {
        Option<String> dataApiType = Option.empty();
        JsonNode dataApiTypeNode = node.get("dataapi-convert-type");
        if (dataApiTypeNode != null) {
            dataApiType = Option.of(dataApiTypeNode.textValue());
        }
        return dataApiType;
    }
}
