package ru.yandex.chemodan.app.dataapi.utils.dataconversion;

import org.junit.Test;

import ru.yandex.bolts.collection.Option;
import ru.yandex.chemodan.app.dataapi.test.UnitTestBase;
import ru.yandex.misc.test.Assert;

/**
 * @author Denis Bakharev
 */
public class ConversionSettingsLoaderTest extends UnitTestBase {
    @Test
    public void extractSettings() throws Exception {
        String jsonSchema = readResource("JsonSchemaForSettingsLoader.json");

        NodeConversionSettings settings = ConversionSettingsLoader.loadFromJsonSchema(jsonSchema);

        assertEquals(4, "object", Option.empty(), settings);

        assertEquals(0, "boolean", Option.empty(), settings, "~");
        assertEquals(0, "string", Option.of("datetime"), settings, "datetimeKey");
        assertEquals(2, "object", Option.of("flat-object"), settings, "objectKey");
        assertEquals(0, "integer", Option.empty(), settings, "objectKey", "objectIntegerKey");
        assertEquals(0, "string", Option.of("byte-array"), settings, "objectKey", "objectByteArrayKey");
        assertEquals(1, "array", Option.empty(), settings, "arrayOfObjectsKey");
        assertEquals(1, "object", Option.empty(), settings, "arrayOfObjectsKey", "0");
        assertEquals(0, "string", Option.empty(), settings, "arrayOfObjectsKey", "0", "/");

    }

    private void assertEquals(
            int childCount,
            String jsonType,
            Option<String> dataApiType,
            NodeConversionSettings settings,
            String... childSettingsPath)
    {
        NodeConversionSettings target = settings;
        for (String elemName : childSettingsPath) {
            target = target.children.getTs(elemName);
        }

        Assert.equals(jsonType, target.jsonType);
        Assert.equals(dataApiType, target.dataApiType);
        Assert.equals(childCount, target.children.size());
    }
}
