package ru.yandex.chemodan.app.dataapi.utils.dataconversion;

import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.bender.parse.BenderJsonNode;

/**
 * @author Denis Bakharev
 */
public class ConverterContext<TNode extends BenderJsonNode> {
    public final Option<ConverterContext<TNode>> parent;
    public final TNode dataNode;
    public final NodeConversionSettings settings;

    public ConverterContext(
            Option<ConverterContext<TNode>> parent,
            NodeConversionSettings settings,
            TNode dataNode)
    {
        this.parent = parent;
        this.dataNode = dataNode;
        this.settings = settings;
    }

    public ConverterContext<TNode> withChildNode(String name) {
        return new ConverterContext<> (
                Option.of(this),
                settings.children.getTs(name),
                (TNode) dataNode.getField(name).getOrNull());
    }

    public ConverterContext<TNode> withChildNode(int index) {
        //т.к мы не поддерживаем массивы с различными типами данных, то всегда используем настройки для первого элемента
        NodeConversionSettings childSchemaSettings = settings.children.getTs("0");

        return new ConverterContext<>(
                Option.of(this),
                childSchemaSettings,
                (TNode) dataNode.getArrayElements().get(index));
    }
}
