package ru.yandex.chemodan.app.dataapi.utils.dataconversion;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.test.UnitTestBase;
import ru.yandex.misc.test.Assert;

/**
 * @author Denis Bakharev
 */
public class DataConversionUnitTestBase extends UnitTestBase {

    protected MapF<String, DataField> doConvertCycle(String jsonSchema, String jsonInput) {
        FormatConverter converter = new FormatConverter(jsonSchema);
        MapF<String, DataField> mapFromInputJson = converter.toDataFields(jsonInput);
        String convertedJson = converter.toJson(mapFromInputJson);
        MapF<String, DataField> mapFromConvertedJson = converter.toDataFields(convertedJson);

        Assert.equals(mapFromInputJson, mapFromConvertedJson);

        return mapFromConvertedJson;
    }

    protected void assertContains(MapF<String, DataField> map, String name, DataField data) {
        Assert.equals(map.getTs(name), data);
    }
}
