package ru.yandex.chemodan.app.dataapi.utils.dataconversion;

import com.fasterxml.jackson.core.JsonGenerator;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.dataapi.utils.dataconversion.typeconverters.TypeConverter;
import ru.yandex.chemodan.app.dataapi.utils.serializers.datafieldmap.DataFieldNode;
import ru.yandex.misc.bender.serialize.BenderJsonGeneratorWrapper;

/**
 * @author Denis Bakharev
 */
public class DataFieldToJsonConverter extends AbstractConverter<BenderJsonGeneratorWrapper, DataFieldNode> {

    public DataFieldToJsonConverter(MapF<String, TypeConverter> typeConverters, JsonGenerator jsonGenerator) {
        super(typeConverters, new BenderJsonGeneratorWrapper(jsonGenerator));
    }

    @Override
    public void convert(TypeConverter converter, ConverterContext<DataFieldNode> context) {
        converter.writeJson(this, context);
    }
}
