package ru.yandex.chemodan.app.dataapi.utils.dataconversion;


import ru.yandex.bolts.collection.ListF;
import ru.yandex.bolts.collection.MapF;
import ru.yandex.bolts.collection.Option;
import ru.yandex.misc.lang.DefaultObject;

/**
 * @author Denis Bakharev
 */
public class NodeConversionSettings extends DefaultObject {
    public final String nodeName;
    public final MapF<String, NodeConversionSettings> children;
    public final String jsonType;
    public final Option<String> dataApiType;

    public NodeConversionSettings(
            String nodeName,
            ListF<NodeConversionSettings> children,
            String jsonType,
            Option<String> dataApiType)
    {
        this.nodeName = nodeName;
        this.children = children.toMapMappingToKey(s -> s.nodeName);
        this.jsonType = jsonType;
        this.dataApiType = dataApiType;
    }

    public String getActualType() {
        return dataApiType.getOrElse(jsonType);
    }
}
