package ru.yandex.chemodan.app.dataapi.utils.dataconversion.typeconverters;

import ru.yandex.bolts.collection.ListF;
import ru.yandex.chemodan.app.dataapi.utils.dataconversion.AbstractConverter;
import ru.yandex.chemodan.app.dataapi.utils.dataconversion.ConverterContext;
import ru.yandex.misc.bender.parse.BenderJsonNode;

/**
 * @author Denis Bakharev
 */
public class ArrayTypeConverter extends UniformConverter {
    @Override
    public String getConvertedTypeName() {
        return "array";
    }

    @Override
    protected <TNode extends BenderJsonNode> void write(
            AbstractConverter<?, TNode> converter, ConverterContext<TNode> context)
    {
        converter.writer.writeArrayStart();

        ListF<BenderJsonNode> node = context.dataNode.getArrayElements();
        for (int i = 0; i < node.size(); i++) {
            converter.convert(context.withChildNode(i));
        }

        converter.writer.writeArrayEnd();
    }
}
