package ru.yandex.chemodan.app.dataapi.utils.dataconversion.typeconverters;

import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.utils.dataconversion.ConverterContext;
import ru.yandex.chemodan.app.dataapi.utils.dataconversion.DataFieldToJsonConverter;
import ru.yandex.chemodan.app.dataapi.utils.dataconversion.JsonToDataFieldConverter;
import ru.yandex.chemodan.app.dataapi.utils.serializers.datafieldmap.DataFieldNode;
import ru.yandex.misc.bender.parse.JacksonJsonNodeWrapper;
import ru.yandex.misc.codec.FastBase64Coder;

/**
 * @author Denis Bakharev
 */
public class ByteArrayTypeConverter extends TypeConverter {
    @Override
    public String getConvertedTypeName() {
        return "byte-array";
    }

    @Override
    public void writeDataField(JsonToDataFieldConverter converter, ConverterContext<JacksonJsonNodeWrapper> context) {
        byte[] arr = FastBase64Coder.decode(context.dataNode.getValueAsString());
        converter.writer.write(DataField.bytes(arr));
    }

    @Override
    public void writeJson(DataFieldToJsonConverter converter, ConverterContext<DataFieldNode> context) {
        String base64String = FastBase64Coder.encodeToString(context.dataNode.dataField.bytesValue());
        converter.writer.writeString(base64String);
    }
}
