package ru.yandex.chemodan.app.dataapi.utils.dataconversion.typeconverters;

import org.junit.Test;

import ru.yandex.bolts.collection.MapF;
import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.utils.dataconversion.DataConversionUnitTestBase;
import ru.yandex.misc.test.Assert;

/**
 * @author Denis Bakharev
 */
public class ByteArrayTypeConverterTest extends DataConversionUnitTestBase {

    @Test
    public void doConversionTest() {

        String jsonSchema =
                "{\n"
                + "  \"type\": \"object\",\n"
                + "  \"properties\": {\n"
                + "    \"prop1\": {\"type\": \"string\", \"dataapi-convert-type\":\"byte-array\"}\n"
                + "  }\n"
                + "}";

        String jsonInput =
                "{ \"prop1\":\"TWFu\" }"; // Man (M=77, a=97, n=110); base64("Man") = "TWFu"

        MapF<String, DataField> map = doConvertCycle(jsonSchema, jsonInput);

        Assert.equals(1, map.size());
        Assert.equals(DataField.bytes(new byte[]{77, 97, 110}), map.getTs("prop1"));
    }
}
