package ru.yandex.chemodan.app.dataapi.utils.dataconversion.typeconverters;

import org.joda.time.DateTime;

import ru.yandex.chemodan.app.dataapi.api.data.field.DataField;
import ru.yandex.chemodan.app.dataapi.utils.dataconversion.ConverterContext;
import ru.yandex.chemodan.app.dataapi.utils.dataconversion.DataFieldToJsonConverter;
import ru.yandex.chemodan.app.dataapi.utils.dataconversion.JsonToDataFieldConverter;
import ru.yandex.chemodan.app.dataapi.utils.serializers.datafieldmap.DataFieldNode;
import ru.yandex.misc.bender.parse.JacksonJsonNodeWrapper;

/**
 * @author Denis Bakharev
 */
public class DateTimeTypeConverter extends TypeConverter {
    @Override
    public String getConvertedTypeName() {
        return "datetime";
    }

    @Override
    public void writeDataField(
            JsonToDataFieldConverter converter, ConverterContext<JacksonJsonNodeWrapper> context)
    {
        converter.writer.write(DataField.dateTime(DateTime.parse(context.dataNode.getValueAsString())));
    }

    @Override
    public void writeJson(
            DataFieldToJsonConverter converter, ConverterContext<DataFieldNode> context)
    {
        converter.writer.writeString(context.dataNode.dataField.dateTimeValue().toString());
    }
}
